// Popup script for toggling translation
const toggle = document.getElementById('toggleTranslation');
const status = document.getElementById('status');

// Load saved state
chrome.storage.sync.get(['enabled'], (result) => {
  const enabled = result.enabled !== false; // Default to true
  toggle.checked = enabled;
  updateStatus(enabled);
});

// Handle toggle change
toggle.addEventListener('change', async () => {
  const enabled = toggle.checked;

  // Save state
  chrome.storage.sync.set({ enabled });

  // Update status
  updateStatus(enabled);

  // Send message to all tabs
  const tabs = await chrome.tabs.query({});
  tabs.forEach(tab => {
    chrome.tabs.sendMessage(tab.id, {
      action: 'toggle',
      enabled: enabled
    }).catch(() => {
      // Ignore errors for tabs that don't have content script
    });
  });
});

function updateStatus(enabled) {
  status.textContent = enabled ? 'Active' : 'Paused';
  status.style.color = enabled ? '#4CAF50' : '#888';
}
